import { Module } from '@nestjs/common';

import { OfferingService } from '../offering/offering.service';
import { CommonUtils } from '../../utils/common.utils';
import { AddressValidatorService } from '../../utils/address-validator-service';
import { LoggerInterceptor } from '../../interceptors';
import { PurchasesService } from './purchases.service';

@Module({
  providers: [
    PurchasesService,
    OfferingService,
    CommonUtils,
    AddressValidatorService,
    LoggerInterceptor,
  ],
  exports: [PurchasesService],
})
export class PurchasesSharedModule {}
