import { ApiProperty } from '@nestjs/swagger';

import {
  IsString,
  IsNumber,
  IsNumberString,
  Matches,
  MaxLength,
  MinLength,
  Min,
  IsNotEmpty,
  Length,
} from 'class-validator';

export class TradingHistoryRequestDto {
  @ApiProperty({ description: 'Offering id (oid)' })
  @IsString()
  @IsNotEmpty()
  oid: string;
}

export class Token1AddressDto {
  @ApiProperty()
  @IsString()
  @Matches('^0x[0-9a-fA-F]{40}$')
  @Length(42, 42)
  addr1: string;
}

export class Token2AddressDto {
  @ApiProperty()
  @IsString()
  @Matches('^0x[0-9a-fA-F]{40}$')
  @Length(42, 42)
  addr2: string;
}

export class Token1IndexDto {
  @ApiProperty()
  @Matches('^[0-9]+$')
  @Min(0)
  indexno1: string;
}

export class Token2IndexDto {
  @ApiProperty()
  @Matches('^[0-9]+$')
  @Min(0)
  indexno2: string;
}

export class TokenPairNoDto {
  @ApiProperty()
  @IsNumber()
  @MinLength(1)
  @MaxLength(65)
  pairno: string;
}
