import { Module } from '@nestjs/common';
import { TradingHistoryService } from './trading-history.service';
import { TradingHistoryServiceMock } from './trading-history.service.mock';
import { GovernanceService } from '../governance/governance.service';
import { OfferingService } from '../offering/offering.service';
import { CommonUtils } from '../../utils/common.utils';
import { AddressValidatorService } from '../../utils/address-validator-service';
import { LoggerInterceptor } from '../../interceptors';

@Module({
  providers: [
    TradingHistoryService,
    GovernanceService,
    OfferingService,
    CommonUtils,
    AddressValidatorService,
    LoggerInterceptor,
  ],
  exports: [TradingHistoryService],
})
export class TradingHistorySharedModule {}
