import { Injectable, Logger } from '@nestjs/common';
import { ContractAddresses, getContractAddresses } from '@contracts';
@Injectable()
export class AddressValidatorService {
  public contractAddresses: ContractAddresses;
  private logger = new Logger(AddressValidatorService.name);

  constructor() {
    this.logger.log(
      'AddressValidatorService initialized for network ' +
        process.env.HARDHAT_NETWORK,
    );
    this.contractAddresses = getContractAddresses(process.env.HARDHAT_NETWORK);
  }
}
