import {
  registerDecorator,
  ValidationArguments,
  ValidationOptions,
} from 'class-validator';

export function HasAtLeastOneFieldPresent(
  fields: string[],
  validationOptions?: ValidationOptions,
) {
  return function (object: object, propertyName: string) {
    registerDecorator({
      name: 'hasAtLeastOneFieldPresent',
      target: object.constructor,
      propertyName: propertyName,
      options: validationOptions,
      constraints: [fields],
      validator: {
        validate(value: any, args: ValidationArguments) {
          const [relatedFields] = args.constraints;
          const object = args.object as any;
          return relatedFields.some(
            (field: string) =>
              object[field] !== undefined &&
              object[field] !== null &&
              object[field] !== '',
          );
        },
        defaultMessage(args: ValidationArguments) {
          return `At least one of the fields ${args.constraints[0].join(
            ', ',
          )} must be present`;
        },
      },
    });
  };
}
