import { registerDecorator, ValidationOptions } from 'class-validator';
import { ethers } from 'ethers';

export function IsEthAddress(validationOptions?: ValidationOptions) {
  return function (object: object, propertyName: string) {
    registerDecorator({
      name: 'isLongerThan',
      target: object.constructor,
      propertyName: propertyName,
      constraints: ['address'],
      options: validationOptions,
      validator: {
        validate(value: any) {
          return ethers.utils.isAddress(value);
        },
      },
    });
  };
}
