import * as path from 'path';
import * as fs from 'fs';
import findPackageJsonDir from './findRootDir';
export function getContractABI(contractName: string) {
  const rootDir = findPackageJsonDir(__dirname);
  const fullPath = path.join(
    rootDir,
    `libs/contracts/artifacts/libs/contracts/src/contracts/${contractName}.sol/${contractName}.json`,
  );
  return JSON.parse(fs.readFileSync(fullPath, 'utf8')).abi;
}
