// SPDX-License-Identifier: MIT
pragma solidity ^0.8.17;

import './BaseDataAccess.sol';

// PAYG (pay-as-you-use) is a payment method where users are charged for the full
// range of data, when accessed, whether actually downloaded or not

contract DataAccessPayAsYouGo is BaseDataAccess {
    function initialize(
        string memory _name,
        string memory _symbol,
        string memory _uri
    ) public override initializer {
        BaseDataAccess.initialize(_name, _symbol, _uri);
    }

    /**
     * @dev Returns the same URI for all token IDs.
     * The `super.uri(0)` call retrieves the base URI set for the contract.
     * The `0` is a placeholder, as the base URI does not contain the `{id}` placeholder
     * and thus returns the same URI regardless of the token ID passed.
     */
    function uri(uint256) public view override returns (string memory) {
        return super.uri(0);
    }
    function ver() public pure virtual returns (uint8) {
        return 1;
    }
}
