// SPDX-License-Identifier: MIT

pragma solidity ^0.8.17;

// Interface for DataAccess contract
interface IDataAccess {
    function getMaxSupply(uint256 tokenId) external view returns (uint256);

    function getDataProviderRight(
        address _dataProvider
    ) external view returns (bool);

    function setDataProviders(
        address _dataProvider,
        bool _hasRights,
        bytes calldata _data
    ) external;

    function addAsset(
        uint256 _assetId,
        string memory _tokenUri,
        uint256 _maxSupply,
        uint256 _tokenOfferAmount,
        uint256 _offerExpirationTime,
        bytes memory _data
    ) external;

    function getAssetOwnerDataProvider(
        uint256 _tokenId
    ) external view returns (address);

    function purchaseAccessRight(uint256 _tokenId, bytes memory _data) external;

    function burnAccessToken(
        address _from,
        uint256 _assetId,
        bytes memory _data
    ) external;

    function pause() external;

    function unpause() external;
}
