// SPDX-License-Identifier: MIT
pragma solidity ^0.8.17;

import '@openzeppelin/contracts/utils/structs/EnumerableSet.sol';

library LibTradingManagementStorage {
    bytes32 constant TRADING_MANAGEMENT_STORAGE_POSITION =
        keccak256('diamond.storage.TradingManagementStorage');

    struct TradingManagementStorage {
        address bourseContractAddress;
        address offeringTokenContract;
        address paymentTokenContract;
        address paygDataAccessContract;
        address payuDataAccessContract;
        address subscriptionDataAccessContract;
        /*  Replaced with the array versions below 
        mapping(address => mapping(uint256 => uint256)) accessRightSubscriptionPurchaseTime;
        mapping(address => mapping(uint256 => uint256)) accessRightPAYGPurchaseTime;
        mapping(address => mapping(uint256 => uint256)) accessRightPAYUPurchaseTime;
        */
        // Expiration timestamps (purchase time + duration)
        mapping(address => mapping(uint256 => uint256[])) dataAccessExpirationPAYU;
        mapping(address => mapping(uint256 => uint256[])) dataAccessExpirationPAYG;
        mapping(address => mapping(uint256 => uint256[])) dataAccessExpirationSubscription;
        mapping(address => EnumerableSet.UintSet) userOfferIdsPAYU;
        mapping(address => EnumerableSet.UintSet) userOfferIdsPAYG;
        mapping(address => EnumerableSet.UintSet) userOfferIdsSUB;
    }

    function tradingManagementStorage()
        internal
        pure
        returns (TradingManagementStorage storage tms)
    {
        bytes32 position = TRADING_MANAGEMENT_STORAGE_POSITION;
        // solhint-disable-next-line no-inline-assembly
        assembly {
            tms.slot := position
        }
    }
}
