import { ethers } from 'hardhat';
import { Signers } from '../types';
import { network } from 'hardhat';
import { artifacts } from 'hardhat';
import { deployContracts } from '../../../scripts/deployProxy';
import { deployDiamond as deployBourse } from '../../../scripts/deployBourse';
import { deployDiamond as deployGovernance } from '../../../scripts/deployGovernance';

import {
  OfferingToken,
  PaymentToken,
  Escrow,
  Bourse,
  DataAccessPayAsYouGo,
  DataAccessPayAsYouUse,
  DataAccessSubscription,
  Governance,
} from '../../../../types';

export interface FameContracts {
  paymentTokenContract: PaymentToken;
  escrowContract: Escrow;
  bourseContract: Bourse;
  offeringTokenContract: OfferingToken;
  dataAccessPayAsYouGoContract: DataAccessPayAsYouGo;
  dataAccessPayAsYouUseContract: DataAccessPayAsYouUse;
  dataAccessSubscriptionContract: DataAccessSubscription;
  governanceContract: Governance;
  permissionsContract?: any;
}

export async function getSigners(): Promise<Signers> {
  const signers = {} as Signers;
  const signerWithAddress = await ethers.getSigners();
  signers.admin = signerWithAddress[0];
  signers.signer1 = signerWithAddress[1];
  signers.signer2 = signerWithAddress[2];
  signers.signer3 = signerWithAddress[3];
  signers.signer4 = signerWithAddress[4];
  signers.signer5 = signerWithAddress[5];
  signers.signer6 = signerWithAddress[6];
  signers.signer7 = signerWithAddress[7];
  signers.signer8 = signerWithAddress[8];
  signers.signer9 = signerWithAddress[9];
  return signers;
}

export async function deployContractsForTests(options?: {
  shouldResetNetwork?: boolean;
  shouldSaveInfo?: boolean;
}): Promise<FameContracts> {
  if (options?.shouldResetNetwork) {
    console.log('--------------- Resetting Test Hardhat network ----------');
    await network.provider.send('hardhat_reset');
  }

  const contracts = await deployContracts({
    shouldSaveInfo: options?.shouldSaveInfo ?? true,
  });

  let diamondAddress = await deployBourse({
    saveInfo: options?.shouldSaveInfo ?? true,
    showInfo: false,
  });
  // Load ABIs from compiled contract JSON files and combine the ABIs
  let artifact = await artifacts.readArtifact('BourseFacet');
  let abi1 = artifact.abi;
  artifact = await artifacts.readArtifact('DiamondCutFacet');
  const abi2 = artifact.abi;
  artifact = await artifacts.readArtifact('DiamondLoupeFacet');
  const abi3 = artifact.abi;
  artifact = await artifacts.readArtifact('OwnershipFacet');
  const abi4 = artifact.abi;
  // Combine the ABIs (no need to check for duplicates)
  let combinedAbi = [...abi1, ...abi2, ...abi3, ...abi4];
  contracts.bourseContract = await ethers.getContractAt(
    combinedAbi,
    diamondAddress,
  );

  diamondAddress = await deployGovernance({
    shouldSaveInfo: options?.shouldSaveInfo ?? false,
  });
  // Load ABIs from compiled contract JSON files and combine the ABIs
  artifact = await artifacts.readArtifact('GovernanceFacet');
  abi1 = artifact.abi;
  // Combine the ABIs (no need to check for duplicates)
  combinedAbi = [...abi1, ...abi2, ...abi3, ...abi4];
  contracts.governanceContract = await ethers.getContractAt(
    combinedAbi,
    diamondAddress,
  );

  return contracts;
}
