import { BigNumber, ethers } from 'ethers';
import { fetchJson } from 'ethers/lib/utils';
import * as path from 'path';
import * as fs from 'fs';

export function getAbi(address: string): Promise<unknown> {
  const fullPath = path.join('test', 'abi', `${address}.json`);
  if (fs.existsSync(fullPath)) {
    return Promise.resolve(JSON.parse(fs.readFileSync(fullPath, 'utf-8')));
  }
  return fetchJson(
    `https://api.etherscan.io/api?module=contract&action=getabi&address=${address}`,
  ).then(function (data) {
    fs.writeFileSync(fullPath, data.result);
    console.warn(`Wrote abi file ${fullPath}`);
    return JSON.parse(data.result);
  });
}

export function toBN(data: string): BigNumber {
  return ethers.BigNumber.from(data);
}

export function fEth(data: string | BigNumber | bigint): string {
  if (ethers.BigNumber.isBigNumber(data)) {
    return ethers.utils.formatEther(data);
  }
  return ethers.utils.formatEther(ethers.BigNumber.from(data));
}
