// SPDX-License-Identifier: MIT
pragma solidity ^0.8.17;

contract MockPermission {
    mapping(address => bool) private permitted;
    bool private readOnly;
    address[] private accountList;
    event AccountAdded(bool accountAdded, address accountAddress);
    event AccountRemoved(bool accountRemoved, address accountAddress);

    constructor() {
        // Simple constructor - no bullshit parameters
    }

    function accountPermitted(address _account) external view returns (bool) {
        return permitted[_account];
    }

    function addAccount(address account) external returns (bool) {
        permitted[account] = true;
        emit AccountAdded(true, account);
        return true;
    }

    // Adds MULTIPLE accounts
    function addAccounts(address[] memory accounts) external returns (bool) {
        for (uint i = 0; i < accounts.length; i++) {
            permitted[accounts[i]] = true;
            emit AccountAdded(true, accounts[i]);
        }
        return true;
    }

    function removeAccount(address account) external returns (bool) {
        permitted[account] = false;
        emit AccountRemoved(true, account);
        return true;
    }

    function enterReadOnly() external returns (bool) {
        readOnly = true;
        return true;
    }

    function exitReadOnly() external returns (bool) {
        readOnly = false;
        return true;
    }

    function isReadOnly() external view returns (bool) {
        return readOnly;
    }

    function getContractVersion() external pure returns (uint256) {
        return 1;
    }

    function getAccounts() external view returns (address[] memory) {
        return accountList;
    }

    function getSize() external pure returns (uint256) {
        return 0;
    }

    function getByIndex(uint256) external pure returns (address) {
        return address(0);
    }

    function transactionAllowed(
        address,
        address,
        uint256,
        uint256,
        uint256,
        bytes calldata
    ) external pure returns (bool) {
        return true;
    }
}
