import { ethers } from 'hardhat';
import { getDeployedDATContractAddress } from '../contract-helpers/contract-address-helpers';

export async function readUri(tokenType: string, hre: any): Promise<void> {
  const { network } = hre;

  if (!tokenType) {
    throw new Error('Please provide tokenType parameter');
  }

  console.log(
    `Reading URI for ${tokenType} token on network ${network.name}...`,
  );

  const contractAddress = getDeployedDATContractAddress(
    network.name,
    tokenType,
  );
  console.log(
    `Looking for contract for ${tokenType} at address: ${contractAddress}`,
  );

  const contract = await ethers.getContractAt(
    'BaseDataAccess',
    contractAddress,
  );

  console.log(`Found ${tokenType} contract at address: ${contractAddress}`);

  console.log('Reading current URI...');
  const currentUri = await contract.uri(0);

  console.log(`Current URI for ${tokenType} contract is: ${currentUri}`);
}

// Main execution pattern to use async/await and handle errors properly
if (require.main === module) {
  const args = process.argv.slice(2);
  if (args.length < 1) {
    console.error('Usage: npx hardhat run readUri.ts <tokenType>');
    process.exit(1);
  }
  const [tokenType] = args;

  // Import hardhat runtime environment
  import('hardhat').then((hardhat) => {
    const hre = hardhat;

    readUri(tokenType, hre)
      .then(() => process.exit(0))
      .catch((error) => {
        console.error(error);
        process.exit(1);
      });
  });
}

exports.readUri = readUri;
