import { keccak256, toUtf8Bytes } from 'ethers/lib/utils';
import { BigNumber } from 'ethers';

/**
 * Returns uint256 tokenId as decimal string from oid (string).
 */
export function getIDHashHelper(oid: string): string {
  const hash = keccak256(toUtf8Bytes(oid));
  return BigNumber.from(hash).toString();
}
