# Deployment How-To Guide for the FAME Project

This guide provides step-by-step instructions on how to prepare deployment configuration files for the FAME project. By following these steps, you will be able to build, configure, and deploy your applications seamlessly.

---

## Table of Contents

- [Deployment How-To Guide for the FAME Project](#deployment-how-to-guide-for-the-fame-project)
  - [Table of Contents](#table-of-contents)
  - [1. Create and Push Docker Image(s) of Your Applications](#1-create-and-push-docker-images-of-your-applications)
    - [Steps:](#steps)
    - [Notes:](#notes)
  - [2. Add Configuration Files to the `fame-integration` Project](#2-add-configuration-files-to-the-fame-integration-project)
    - [Steps:](#steps-1)
  - [3. Create Configuration in Argo CD](#3-create-configuration-in-argo-cd)
    - [Steps:](#steps-2)
    - [Notes:](#notes-1)
  - [4. Monitor Your Application in Kubernetes Dashboard](#4-monitor-your-application-in-kubernetes-dashboard)
    - [Steps:](#steps-3)

---

## 1. Create and Push Docker Image(s) of Your Applications

To deploy your application, you need to containerize it using Docker and push the image to our Docker image registry.

### Steps:

- **Set Up GitLab CI/CD Pipeline:**
  - Create a `.gitlab-ci.yml` file in your source code repository.
  - Define CI/CD jobs that build and test your application.
  - Configure the pipeline to build a Docker image of your application.

- **Authenticate with the Docker Registry:**
  - Ensure your pipeline includes authentication steps to connect with the [Harbor FAME Docker Image Registry](https://harbor.gftinnovation.eu/harbor/projects/40/repositories).
  - Use secure methods to store and access credentials, such as GitLab CI/CD variables.

- **Build and Push the Docker Image:**
  - Use Docker commands in your pipeline to build the image:
    ```yaml
    docker build -t harbor.gftinnovation.eu/your-project/your-app:latest .
    ```
  - Push the image to the registry:
    ```yaml
    docker push harbor.gftinnovation.eu/your-project/your-app:latest
    ```
  - Replace `your-project` and `your-app` with your actual project and application names.

### Notes:

- **Tagging:** Use proper tagging conventions (e.g., `latest`, `v1.0.0`, commit SHA) for version control.
- **Optimization:** Write an efficient `Dockerfile` to minimize image size and improve security.
- **Testing:** Incorporate testing stages in your pipeline to ensure the image is reliable before pushing.

---

## 2. Add Configuration Files to the `fame-integration` Project

Your application requires Kubernetes configuration files to define how it should run in the cluster.

### Steps:

- **Clone the `fame-integration` Repository:**
  - Access the repository where deployment configurations are stored.
  - Clone it to your local machine:
    ```bash
    git clone https://gitlab.gftinnovation.eu/fame/fame-integration.git
    ```

- **Navigate to the Appropriate Folder:**
  - If a folder for your service exists, navigate to it.
  - If not, create a new folder named after your service.

- **Create Kubernetes YAML Files:**
  - Use existing configurations in the `tm` folder as a reference.
  - Create necessary `.yaml` files, such as:
    - `deployment.yaml` for Deployment configurations.
    - `service.yaml` for Service definitions.
    - `ingress.yaml` if you need external access.
    - `configmap.yaml` and `secret.yaml` for configurations and sensitive data.

- **Define Your Deployment:**
  - Specify the Docker image to use:
    ```yaml
    image: harbor.gftinnovation.eu/your-project/your-app:latest
    ```
  - Set resource requests and limits.
  - Define environment variables and mount points if necessary.

- **Commit and Push Changes:**
  - Add your files to Git:
    ```bash
    git add your-service/
    git commit -m "Add deployment configurations for Your Service"
    git push origin main
    ```

---

## 3. Create Configuration in Argo CD

Argo CD automates the deployment of your applications to the Kubernetes cluster.

### Steps:

- **Access Argo CD Dashboard:**
  - Open [Argo CD](https://argocd.gftinnovation.eu/).
  - Log in using your credentials.

- **Create a New Application:**
  - Click on **New App**.
  - Fill out the **General** settings:
    - **Application Name:** Unique name for your application.
    - **Project:** Select the appropriate project, e.g., `default`.
  - Configure the **Source** settings:
    - **Repository URL:** URL of the `fame-integration` Git repository.
    - **Revision:** Branch or tag to deploy from, e.g., `main`.
    - **Path:** Relative path to your service's folder in the repository.
  - Set the **Destination** settings:
    - **Cluster:** Specify the Kubernetes cluster (usually leave as default).
    - **Namespace:** Kubernetes namespace where your application will be deployed (`fame`).

- **Configure Sync Policy:**
  - Decide whether to enable automated syncing.
  - Set up any needed sync options, like pruning and self-healing.

- **Save and Deploy:**
  - Click **Create** to save the application configuration.
  - Once created, select your application and click **Sync** to deploy.

### Notes:

- **Permissions:** Ensure you have the necessary permissions to create and manage applications in Argo CD.
- **Monitoring:** Argo CD provides real-time status of your deployments. Use it to monitor health and sync status.
- **Troubleshooting:** If deployment fails, check the Argo CD logs and events for error messages.

---

## 4. Monitor Your Application in Kubernetes Dashboard

After deployment, use the Kubernetes Dashboard to monitor the status and performance of your application.

### Steps:

- **Access the Kubernetes Dashboard:**
  - Navigate to the [Kubernetes Dashboard](https://k8s-dashboard.gftinnovation.eu/).
  - You will be prompted to log in.


---
