#!/bin/sh

echo "Starting entrypoint script..."
echo "VITE_CLAIM_API=${VITE_CLAIM_API}"
echo "VITE_STATUS_API=${VITE_STATUS_API}"

# Check if placeholders exist before replacement
echo "Checking for placeholders in JS files..."
find /usr/share/nginx/html -name "*.js" -type f -exec grep -l "__VITE_CLAIM_API__" {} +
find /usr/share/nginx/html -name "*.js" -type f -exec grep -l "__VITE_STATUS_API__" {} +

# Replace environment variable placeholders in built JavaScript files
echo "Replacing placeholders with environment variables..."

# Find and replace in all .js files in the nginx html directory
find /usr/share/nginx/html -name "*.js" -type f -exec sed -i "s|__VITE_CLAIM_API__|${VITE_CLAIM_API}|g" {} +
find /usr/share/nginx/html -name "*.js" -type f -exec sed -i "s|__VITE_STATUS_API__|${VITE_STATUS_API}|g" {} +

# Verify replacement worked
echo "Verifying replacement..."
find /usr/share/nginx/html -name "*.js" -type f -exec grep -l "${VITE_CLAIM_API}" {} +

echo "Replacement complete. Starting nginx..."

# Execute the original command (nginx)
exec "$@"