import { Module } from '@nestjs/common';
import { ConfigModule } from '@nestjs/config';
import { PatInternalModule } from "./modules/pat-internal.module";
import { PatInternalController } from "./controllers/pat-internal.controller";
import { PatInternalService } from "./pats/services/pat-internal.service";
import { PatInternalOfferingRepository } from "./pats/repositories/pat-internal.offering-repository";

@Module({
  imports: [
    ConfigModule.forRoot({
      envFilePath: '.env',
      isGlobal: true,
    }),
    PatInternalModule
  ],
  controllers: [PatInternalController],
  providers: [
    PatInternalService,
    PatInternalOfferingRepository
  ],
})
export class AppModule {}
