import {
    Controller,
    Post,
    Body,
    HttpCode,
    HttpStatus,
} from '@nestjs/common';

import { PatInternalService } from '../pats/services/pat-internal.service';
import { ApiBearerAuth, ApiOperation, ApiTags } from "@nestjs/swagger";
import { ConfirmationDto } from "../pats/entities/confirmation.dto";
import { PatInternalOfferingRepository } from "../pats/repositories/pat-internal.offering-repository";

@ApiBearerAuth()
@ApiTags('Pricing Advisory Tool - PAT (internal)')
@Controller()
export class PatInternalController {
    constructor(
      private readonly patService: PatInternalService,
      private readonly patInternalOfferingsRepository: PatInternalOfferingRepository,
    ) {}

    @Post('/pat-internal/v1.0/confirmation')
    @HttpCode(HttpStatus.OK)  // explicitne vracia 200 OK
    @ApiOperation({ summary: 'Used for confirmation of the offering' })
    async confirmation(
      @Body() body: ConfirmationDto,
    ): Promise<void> {
        await this.patService.confirmation(body.id, body.offering, this.patInternalOfferingsRepository);
    }
}
