import {NestFactory} from '@nestjs/core';
import {DocumentBuilder, SwaggerModule} from '@nestjs/swagger';
import {AppModule} from './app.module';
import {Logger} from "@nestjs/common";
import * as fs from "fs";
import * as path from "path";
import * as dotenv from 'dotenv';
dotenv.config();

async function bootstrap() {

  const ssl = process.env.SSL === 'true' || false;
  let httpsOptions = null;
  let app;
  if (ssl) {
    const keyPath = process.env.SSL_KEY_PATH || '';
    const certPath = process.env.SSL_CERT_PATH || '';
    const httpsOptions = {
      key: fs.readFileSync(path.join(__dirname, keyPath)),
      cert: fs.readFileSync(path.join(__dirname, certPath)),
    };
    app = await NestFactory.create(AppModule, { httpsOptions });
  } else {
    app = await NestFactory.create(AppModule);
  }
  const port = Number(process.env.PORT) || 7007;
  const hostname = process.env.HOSTNAME || 'localhost';
  const config = new DocumentBuilder()
    .setTitle('Pricing Advisory Tool API')
    .setDescription('')
    .setVersion('1.0')
    .build();
  const document = SwaggerModule.createDocument(app, config);
  SwaggerModule.setup('swagger', app, document);
  const address =
    'http' + (ssl ? 's' : '') + '://' + hostname + ':' + port;
  app.enableCors({
    origin: [address],
    methods: ['GET', 'POST'],
    credentials: true,
  });
  await app.listen(port, hostname, () => {
    Logger.log('Listening at ' + address);
    Logger.log('Swagger is running at ' + address + '/swagger');
  });
}
bootstrap();
